#!/bin/bash

INSTALLER_DIR="$( cd -- "$(dirname -- "$(readlink -f "${BASH_SOURCE}")")" >/dev/null 2>&1 ; pwd -P )"
echo "Installer dir $INSTALLER_DIR"
BUNDLE_NODE_VERSION=$(ls $INSTALLER_DIR | grep -o -E 'node.*\.tar\.gz' | grep -o -E '[0-9]+\.[0-9]+\.[0-9]+')
echo "Node version $BUNDLE_NODE_VERSION"
# Assume the node tarball is in the same directory as this script
tar -xzf $INSTALLER_DIR/node-v${BUNDLE_NODE_VERSION}-linux-x64.tar.gz -C $INSTALLER_DIR
# add node to path in shell profile (~/.bash_profile for now)
# TODO set up the profile for different possible shells
BASH_PROFILE_FILE="$HOME/.bash_profile"
source $BASH_PROFILE_FILE

if test ! -x "$(which node)" ; then
  echo "# Configuration set by AWS ParallelCluster" >> $BASH_PROFILE_FILE
  echo "export PATH=${INSTALLER_DIR}/node-v${BUNDLE_NODE_VERSION}-linux-x64/bin:\$PATH" >> $BASH_PROFILE_FILE
fi
if ! grep 'export PATH='"${INSTALLER_DIR}"':$PATH' $BASH_PROFILE_FILE; then
    echo "# Configuration set by AWS ParallelCluster" >> $BASH_PROFILE_FILE
    echo "export PATH=${INSTALLER_DIR}:\$PATH" >> $BASH_PROFILE_FILE
fi
source $BASH_PROFILE_FILE
# verify pcluster is present, node is present, and node is on the path
cp $INSTALLER_DIR/pcluster-exe $INSTALLER_DIR/pcluster
test -f $INSTALLER_DIR/pcluster && echo "pcluster exists"
test -f $INSTALLER_DIR/node-v${BUNDLE_NODE_VERSION}-linux-x64/bin/node && echo "node exists"

NODE_VER=`node --version`
echo "$NODE_VER"
echo "Restart terminal or run \`source $HOME/.bash_profile\` to ensure node is in the PATH variable for the shell environment"
